
#ifndef __EG_COMMON_H__
#define __EG_COMMON_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_WTYPES_H
#include <wtypes.h>
#endif

//#define EG_WIN		1
//#define EG_MAC	1
#define EG_X		1 // We can use X Window function calls
#define EG_POSIX        1 // We have posix conformant headers (Unix)
#define EG_SDL		1 // We use the SDL library for graphic access

#define XMMS		1

#ifdef EG_WIN

	#define EG_WIN32	1

	#define __ByteTo32(r,g,b) \
		( ((r) << 16) | ((g) << 8) | (b) )

	#define	__RGBTo32(r,g,b) \
		( ((r & 0xFF00) << 8) | (g & 0xFF00) | (b >> 8) )

	#define __32ToByte(pixel,r,g,b) \
		r = ( (pixel) >> 16 ) & 0xFF; \
		g = ( (pixel) >> 8  ) & 0xFF; \
		b = (pixel) & 0xFF;

	#define __24ToByte(addr,r,g,b) \
		r = ( (unsigned char*) (addr) )[ 0 ]; \
		g = ( (unsigned char*) (addr) )[ 1 ]; \
		b = ( (unsigned char*) (addr) )[ 2 ];


	#define __32To16(pixel) \
		(((pixel & 0xF80000) >> 9) | \
			((pixel & 0xF800) >> 6) | \
				((pixel & 0xF8) >> 3))

	#define PP_GDHandle		HDC
	#define PP_GrafPtr		HDC
	#define PP_GWorldPtr		HDC
	#define PP_PixMapHandle		HBITMAP
	#define PP_WindowPtr		HWND

	typedef RGBQUAD PixPalEntry;

	#define __SetRGBQUAD( entry, R, G, B ) \
		*( (long*) entry ) = R | ( G << 8 )  | \
			( B << 16 ) | ( PC_RESERVED << 24 );

	#define FILE_SYS_SEP_CHAR		'\\'

#elif EG_MAC

	#include <Types.h>
	#include <Palettes.h>

	#define __ByteTo32(r,g,b) \
		( ((r) << 16) | ((g) << 8) | (b) )

	#define	__RGBTo32(r,g,b) \
		( ((r & 0xFF00) << 8) | (g & 0xFF00) | (b >> 8) )

	#define __32ToByte(pixel,r,g,b) \
		r = ( (pixel) >> 16 ) & 0xFF; \
		g = ( (pixel) >> 8  ) & 0xFF; \
		b = (pixel) & 0xFF;

	#define __24ToByte(addr,r,g,b) \
		r = ( (unsigned char*) (addr) )[ 0 ]; \
		g = ( (unsigned char*) (addr) )[ 1 ]; \
		b = ( (unsigned char*) (addr) )[ 2 ];

	#define __32To16(pixel) \
		( ((pixel & 0xF80000) >> 9) | \
			((pixel & 0xF800) >> 6) | \
				((pixel & 0xF8) >> 3) )

	#define PP_GDHandle		GDHandle
	#define PP_GrafPtr		GrafPtr
	#define PP_GWorldPtr		GWorldPtr
	#define PP_PixMapHandle		PixMapHandle
	#define PP_WindowPtr		WindowPtr

	typedef ColorSpec PixPalEntry;

	#define FILE_SYS_SEP_CHAR		':'

#elif EG_X

	#define __ByteTo32(r,g,b) \
		( ((r) << 16) | ((g) << 8) | (b) )

	#define	__RGBTo32(r,g,b) \
		( ((r & 0xFF00) << 8) | (g & 0xFF00) | (b >> 8) )

	#define __32ToByte(pixel,r,g,b) \
		r = ( (pixel) >> 16 ) & 0xFF; \
		g = ( (pixel) >> 8  ) & 0xFF; \
		b = (pixel) & 0xFF;

	#define __24ToByte(addr,r,g,b) \
		r = ( (unsigned char*) (addr) )[ 0 ]; \
		g = ( (unsigned char*) (addr) )[ 1 ]; \
		b = ( (unsigned char*) (addr) )[ 2 ];


	#define __32To16(pixel) \
		(((pixel & 0xF80000) >> 9) | \
			((pixel & 0xF800) >> 6) | \
				((pixel & 0xF8) >> 3))

	#define PP_GDHandle		void*
	#define PP_GrafPtr		void*
	#define PP_GWorldPtr		void*
	#define PP_PixMapHandle		SDL_Surface*
	#define PP_WindowPtr		void*

	typedef struct _RGBQUAD {
		unsigned char rgbRed, rgbGreen, rgbBlue, alpha;
	}
	PixPalEntry;

	#define __SetRGBQUAD( entry, R, G, B ) \
		*( (long*) entry ) = R | ( G << 8 )  | \
			( B << 16 ) | ( PC_RESERVED << 24 );

	#define FILE_SYS_SEP_CHAR	'/'
#endif

#ifdef WIN_QUICKTIME_PRESENT
#include <MacTypes.h>
#elif EG_X || EG_WIN
typedef struct _Rect {
	short left, top, bottom, right;
}
Rect;

typedef struct _Point {
	short v, h;
}
Point;

typedef struct _RGBColor {
	unsigned short red, green, blue;
}
RGBColor;

typedef struct _ColorSpec {
	short		value;
	RGBColor	rgb;
}
ColorSpec;

typedef void* Movie;
typedef long KeyMap[4];
#endif // EG_X

#ifndef NULL
#define NULL 0L
#endif

#ifndef nil
#define nil 0L
#endif

#ifndef true
#define false 0
#define true !false
#endif

#ifndef WORDS_BIGENDIAN
#define MCC4_TO_INT(str) \
	((str[0] << 24) + (str[1] << 16) + (str[2] << 8) + str[3])

#define MCC3_TO_INT(str) \
	((str[0] << 16) + (str[1] << 8) + str[2])

#define MCC2_TO_INT(str) \
	((str[0] << 8) + str[1])
#else
#define MCC4_TO_INT(str) \
	((str[3] << 24) + (str[2] << 16) + (str[1] << 8) + str[0])

#define MCC3_TO_INT(str) \
	((str[2] << 16) + (str[1] << 8) + str[0])

#define MCC2_TO_INT(str) \
	((str[1] << 8) + str[0])
#endif

#define __16To5Bit(pixel,R,G,B)		\
	R = pixVal >> 10;		\
	G = (pixVal >> 5) & 0x1F; 	\
	B = pixVal & 0x1F;


#define __5BitTo16(r,g,b) \
	( (( (long) r) << 10) | (((long) g) << 5) | ((long) b) )


// Intensity = .2125 * R + .7154 * G + .0721 * B
#define __ByteToIntensity(r,g,b)	(0xFF - ( ( 54 * r + 183 * g + 19 * b + 0x7F ) >> 8 ))

// Multiply coeffs times 255/31 b/c 16 bit color max is 31
#define __5BitToIntensity(r,g,b)	(0xFF - ( ( 444 * R + 1505 * G + 157 * B + 0x7F ) >> 8 ))


#define __RGBTo8(r,g,b)			( r >> 8 )
#define __RGBTo16(r,g,b)		((( ((long) r) & 0xF800) >> 1) | ((((long) g) & 0xF800) >> 6) | (((long) b) >> 11))
#define __REFTo32( rgb ) 		__RGBTo32( rgb.red, rgb.green, rgb.blue )
#define __REFTo16( rgb ) 		__RGBTo16( rgb.red, rgb.green, rgb.blue )

#define __ByteTo16(r,g,b)		( ((r & 0xF8) << 7) | ((g & 0xF8) << 2) | ((b & 0xF8) >> 3) )


// 2114 == 0xFFFF / 0x1F
#define __16ToRGB(pixel,r,g,b) 			\
	R = 2114 * ((pixel >> 10) & 0x1F); 	\
	G = 2114 * ((pixel >>  5) & 0x1F); 	\
	B = 2114 * (pixel & 0x1F);

#define __16ToByte(pixel,r,g,b)		\
	__16ToRGB(pixel,r,g,b) 		\
	R = R >> 8;			\
	G = G >> 8;			\
	B = B >> 8;


#define __invalidate( r ) 		\
	(r).top = 0x7FFF;		\
	(r).left = 0x7FFF;		\
	(r).bottom = - 0x7FFF;		\
	(r).right = - 0x7FFF;

struct HSV_Color {
	unsigned short hue, sat, val;
};

struct LongRect {
	long left, top, right, bottom;
};

struct DblRect {
	double left, top, right, bottom;
};

#ifndef _MIN
 	#define _MIN( a, b ) (( (a) > (b) ) ? (b) : (a) )
 	#define _MAX( a, b ) (( (a) > (b) ) ? (a) : (b) )
	#define _ABS( a )	( (a > 0) ? (a) : -(a) )
#endif

#define __rnd 	(( (float) rand() ) / ( (float) RAND_MAX ))

#endif //__EG_COMMON_H__
